#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_InappropriateTransfusionRequestReport : BaseTest 
	{
		private InappropriateTransfusionRequestReport _testReport;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testReport = new InappropriateTransfusionRequestReport();
		}

		[TearDown]
		protected void TearDown()
		{
			_testReport = null;
		}

		[Test]
		public void Ctor_Pass_1()
		{
			Assert.IsNotNull(_testReport, "Not null");
		}

		[Test]
		public void Ctor_Pass_2()
		{
			Assert.AreEqual( 0, _testReport.BrokenRulesCount );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void Ctor_Fail(){}

		[Test]
		public void GetReportData_Pass()
		{
			Assert.IsNotNull( _testReport.GetReportData() );
		}

		[Test]
		[ExpectedException( typeof(BusinessObjectException) )]
		public void GetReportData_Fail()
		{
			_testReport.StartDate = _testReport.EndDate.AddYears( 100 );
			_testReport.GetReportData();
		}

		[Test]
		public void GetReportCriteriaText_Pass()
		{
			_testReport.StartDate = DateTime.Today.AddYears(-1);
			_testReport.EndDate = DateTime.Today;
			
			Assert.IsTrue( _testReport.GetReportCriteriaText().Length>0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReportCriteriaText_Fail() {}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass() 
		{
			// It's not possible to test printing from unit test.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail() 
		{
			// It's not possible to test printing from unit test.
		}

		[Test]
		public void GetRecordCountEstimate_Pass()
		{
			Assert.IsTrue( _testReport.GetRecordCountEstimate() >= 0 );
		}

		[Test]
		[ExpectedException( typeof(BusinessObjectException) )]
		public void GetRecordCountEstimate_Fail()
		{
			_testReport.StartDate = _testReport.EndDate.AddYears( 1 );
			_testReport.GetRecordCountEstimate();
		}
	}
}

#endif
